%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ im, scar_lines, hist_std_2, improv_param ] = medianCorrection(im, ini_hist_std, histogram_bins,smoothing_level)
%Function medianCorrection:
%Applies to the image im a median correction and a median
%diff correction
%Applies the correction only in case of improvement
%Returns the new image and the new standard deviation
%   Input parameters:
%       - im: current image
%       - ini_hist_std: initial standard deviation
%       - tolerance_std: for the condition: if abs(diff_line_mean(i)) >= mean(diff_line_mean) + tolerance_std*std(diff_line_mean)
%   Output parameters:
%       - im: new image in case of improvement, else previous image (input image)
%       - hist_std_2: new standard deviation after median correction
%       - improv_param: 1 in case of improvement, else 0

%% Severine's Original Code
%     saved_im_0                                  = im;
%     improv_param                                = 1;
%     check_tolerance                             = 1;
%     image_comp_test                             = zeros(size(im(:,:)));
%     line_median                                 = zeros(size(im,1),1);
%     clear A
% 
%     for i                                       = 1:size(im,1)                                                                                                                  % Loops for the number of scanlines                                                            % Subtracts line median each scan line        
%         line_median(i)                          = median(im(i,1:size(im,2)));
%     end
%     diff_line_median                            = diff(line_median)-median(diff(line_median));
%     scar_thresh                                 = 2*std(diff_line_median);
%     image_comp_test(1,1:size(im,2))             = im(1,1:size(im,2)) - median(im(1,1:size(im,2)));
%     for i                                       = 1:length(diff_line_median)                                                                                                                  % Loops for the number of scanlines
%         if abs(diff_line_median(i))             < scar_thresh 
%             A                                   = im(i+1,1:size(im,2)) - image_comp_test(i,1:size(im,2));
%             image_comp_test(i+1,1:size(im,2))   = im(i+1,1:size(im,2)) - median(A(mean(A) - 2*std(A) <= A & A <= mean(A) + 2*std(A)));                                                              % Subtracts line median each scan line
%         else
%             for k                               = 1:size(im,2)
%                 image_comp_test(i+1,k)          = median(image_comp_test(max([find(abs(diff_line_median(1:i)) < scar_thresh,1,'last'),1]),max([1,k-2]):min([k+2,size(im,2)])));
%             end
%         end 
%     end
%     im                                          = image_comp_test;

    
%% Blake's Update Nov 9, 2011    
saved_im_0                                  = im;
improv_param                                = 1;

image_comp_test                             = zeros(size(im));
line_median                                 = zeros(size(im,1),1);
clear A;
clear diff_line_median;
for i                                       = 1:size(im,1)                                                                                                                  % Loops for the number of scanlines                                                            % Subtracts line median each scan line
    line_median(i)                          = median(im(i,1:size(im,2)));
end
diff_line_median                            = diff(line_median)-median(diff(line_median));
scar_thresh                                 = 3*std(diff_line_median);

image_comp_test(1,:)                        = im(1,:) - median(im(1,:));
scar_lines                                  = zeros(1,size(im,1));

for i                                       = 2:length(diff_line_median)                                                                                                                  % Loops for the number of scanlines
    if abs(diff_line_median(i-1))           < scar_thresh 
        A                                   = im(i,:) - image_comp_test(i-1,:);
        image_comp_test(i,:)                = im(i,:) - median(A(median(A) - 2*std(A) <= A & A <= median(A) + 2*std(A)));                                                              % Subtracts line median each scan line
    else
        scar_lines(i)                       = 1;
        for k                               = 1:size(im,1)
            image_comp_test(i,k)            = median(image_comp_test(max([find(abs(diff_line_median(1:i-1)) < scar_thresh,1,'last'),1]),max([1,k-2]):min([k+2,size(im,2)])));
        end
    end
    
end

search_span                                 = 10;
for k                                       = 1:6
    for i                                       = 2:size(im,1)
        diff_counter                            = zeros(1,size(im,2));
        for j                                   = max([1,i-search_span]):i-1
            diff_counter                        = diff_counter + (image_comp_test(i,:)-image_comp_test(j,:));
        end
        image_comp_test(i,:)                    = image_comp_test(i,:)-(median(diff_counter(median(diff_counter) - 2*std(diff_counter) <= diff_counter & diff_counter <= median(diff_counter) + 2*std(diff_counter))))/length(max([1,i-search_span]):i-1);
    end

    for i                                       = size(im,1)-1:-1:1
        diff_counter                            = zeros(1,size(im,2));
        for j                                   = i+1:min([size(im,1),i+search_span])
            diff_counter                        = diff_counter + (image_comp_test(i,:)-image_comp_test(j,:));
        end
        image_comp_test(i,:)                    = image_comp_test(i,:)-(median(diff_counter(median(diff_counter) - 2*std(diff_counter) <= diff_counter & diff_counter <= median(diff_counter) + 2*std(diff_counter))))/length(i+1:min([size(im,1),i+search_span]));
    end
end

im                                          = image_comp_test;    
%% Improvement check
    
            [h_lim x_lim]                           = ecdf(im(:));
            min_hist                                = floor(x_lim(find(h_lim >= 0.02,1)));
            max_hist                                =  ceil(x_lim(find(h_lim >= 0.98,1)));
            image_inside_range                      = im;
            image_inside_range((im < min_hist ))    = NaN;                                                                                                              
            image_inside_range((im > max_hist ))    = NaN;
            image_inside_range_list                 = reshape(im,size(image_inside_range,1)*size(image_inside_range,2),1);                         % Calculates the histogram of the corrected height data (First image only)
            hist_std_2                              = std(image_inside_range_list(~isnan(image_inside_range_list)));
                                                                                                                                                     % Computes the inital standard deviation for improvement check
    

% Checks if the whole median correction improved the image
    if hist_std_2 > ini_hist_std                % First median correction, so check looks at the std of the whole histogram
        im                                      = saved_im_0;
        hist_std_2                              = ini_hist_std;
        improv_param                            = 0;
    end

end

